"use strict";
//
// Copyright 2023 Signal Messenger, LLC.
// SPDX-License-Identifier: AGPL-3.0-only
//
Object.defineProperty(exports, "__esModule", { value: true });
const crypto_1 = require("crypto");
const ByteArray_1 = require("../internal/ByteArray");
const Constants_1 = require("../internal/Constants");
const Native = require("../../../Native");
const CreateCallLinkCredentialRequest_1 = require("./CreateCallLinkCredentialRequest");
const CreateCallLinkCredential_1 = require("./CreateCallLinkCredential");
class CreateCallLinkCredentialRequestContext extends ByteArray_1.default {
    constructor(contents) {
        super(contents, Native.CreateCallLinkCredentialRequestContext_CheckValidContents);
    }
    static forRoomId(roomId) {
        const random = (0, crypto_1.randomBytes)(Constants_1.RANDOM_LENGTH);
        return this.forRoomIdWithRandom(roomId, random);
    }
    static forRoomIdWithRandom(roomId, random) {
        return new CreateCallLinkCredentialRequestContext(Native.CreateCallLinkCredentialRequestContext_NewDeterministic(roomId, random));
    }
    getRequest() {
        return new CreateCallLinkCredentialRequest_1.default(Native.CreateCallLinkCredentialRequestContext_GetRequest(this.contents));
    }
    receive(response, userId, params) {
        return new CreateCallLinkCredential_1.default(Native.CreateCallLinkCredentialRequestContext_ReceiveResponse(this.contents, response.contents, userId.getServiceIdFixedWidthBinary(), params.contents));
    }
}
exports.default = CreateCallLinkCredentialRequestContext;
//# sourceMappingURL=CreateCallLinkCredentialRequestContext.js.map